/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class BondersOrnamentEffect
extends OneShotEffect {
    BondersOrnamentEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each player who controls a permanent named Bonder's Ornament draws a card.";
    }

    private BondersOrnamentEffect(BondersOrnamentEffect effect) {
        super((OneShotEffect)effect);
    }

    public BondersOrnamentEffect copy() {
        return new BondersOrnamentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || game.getBattlefield().getAllActivePermanents(playerId).stream().map(MageObject::getName).noneMatch("Bonder's Ornament"::equals)) continue;
            player.drawCards(1, source, game);
        }
        return true;
    }
}

