/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.OutlawPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TreasureToken;

class BoneyardDesecratorEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("an outlaw");

    BoneyardDesecratorEffect() {
        super(Outcome.GainLife);
        this.staticText = "If an outlaw was sacrificed this way, create a Treasure token";
    }

    private BoneyardDesecratorEffect(BoneyardDesecratorEffect effect) {
        super((OneShotEffect)effect);
    }

    public BoneyardDesecratorEffect copy() {
        return new BoneyardDesecratorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost)) continue;
            SacrificeTargetCost sacrificeCost = (SacrificeTargetCost)cost;
            List permanents = sacrificeCost.getPermanents();
            for (Permanent permanent : permanents) {
                if (!filter.match(permanent, source.getControllerId(), source, game)) continue;
                return new CreateTokenEffect((Token)new TreasureToken()).apply(game, source);
            }
        }
        return false;
    }

    static {
        filter.add((Predicate)OutlawPredicate.instance);
    }
}

