/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BoobyTrapTriggeredAbility
extends TriggeredAbilityImpl {
    public BoobyTrapTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DoIfCostPaid((Effect)new DamageTargetEffect(10, true, "that player"), (Cost)new SacrificeSourceCost(), "", false), false);
    }

    private BoobyTrapTriggeredAbility(BoobyTrapTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DREW_CARD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Card drawn;
        Player controller = game.getPlayer(this.getControllerId());
        if (event.getPlayerId() == null || game.getState() == null || controller == null) {
            return false;
        }
        if (event.getPlayerId().equals(game.getState().getValue(this.getSourceId().toString() + "_opponent")) && (drawn = game.getCard(event.getTargetId())) != null) {
            controller.revealCards((Ability)this, (Cards)new CardsImpl(drawn), game);
            if (drawn.getName().equals(game.getState().getValue(this.getSourceId().toString() + "NAMED_CARD"))) {
                ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
                return true;
            }
        }
        return false;
    }

    public BoobyTrapTriggeredAbility copy() {
        return new BoobyTrapTriggeredAbility(this);
    }

    public String getRule() {
        return "The chosen player reveals each card they draw.<br>When the chosen player draws the named card, sacrifice {this}. If you do, {this} deals 10 damage to that player.";
    }
}

