/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetDiscard;

class BorderlandExplorerEffect
extends OneShotEffect {
    BorderlandExplorerEffect() {
        super(Outcome.Neutral);
        this.staticText = "each player may discard a card. Each player who discarded a card this way may search their library for a basic land card, reveal it, put it into their hand, then shuffle";
    }

    private BorderlandExplorerEffect(BorderlandExplorerEffect effect) {
        super((OneShotEffect)effect);
    }

    public BorderlandExplorerEffect copy() {
        return new BorderlandExplorerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            Card card;
            Cards cardsPlayer;
            Player player;
            HashMap<UUID, Iterator> cardsToDiscard = new HashMap<UUID, Iterator>();
            HashMap<UUID, CardsImpl> cardsToReveal = new HashMap<UUID, CardsImpl>();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null) continue;
                TargetDiscard target = new TargetDiscard(0, 1, new FilterCard(), playerId);
                player.chooseTarget(this.outcome, (Target)target, source, game);
                Iterator cards = new CardsImpl((Collection)target.getTargets());
                cardsToDiscard.put(playerId, cards);
            }
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null || (cardsPlayer = (Cards)cardsToDiscard.get(playerId)) == null) continue;
                for (UUID cardId : cardsPlayer) {
                    card = game.getCard(cardId);
                    player.discard(card, false, source, game);
                }
            }
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                TargetCardInLibrary target;
                player = game.getPlayer(playerId);
                if (player == null || (cardsPlayer = (Cards)cardsToDiscard.get(playerId)) == null || cardsPlayer.isEmpty() || !player.searchLibrary(target = new TargetCardInLibrary(0, 1, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND), source, game) || target.getTargets().isEmpty()) continue;
                CardsImpl cards = new CardsImpl((Collection)target.getTargets());
                cards.addAll((Collection)target.getTargets());
                cardsToReveal.put(playerId, cards);
            }
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null || (cardsPlayer = (Cards)cardsToReveal.get(playerId)) == null) continue;
                for (UUID cardId : cardsPlayer) {
                    card = game.getCard(cardId);
                    CardsImpl cards = new CardsImpl(game.getCard(cardId));
                    if (card == null || cards.isEmpty()) continue;
                    player.revealCards(sourceObject.getIdName() + " (" + player.getName() + ')', (Cards)cards, game);
                    player.moveCards(card, Zone.HAND, source, game);
                    player.shuffleLibrary(source, game);
                }
            }
            return true;
        }
        return false;
    }
}

