/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;

class BorealOutriderEffect
extends ReplacementEffectImpl {
    BorealOutriderEffect() {
        super(Duration.EndOfStep, Outcome.BoostCreature);
        this.staticText = "that creature enters with an additional +1/+1 counter on it";
    }

    private BorealOutriderEffect(BorealOutriderEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Spell spell = (Spell)this.getValue("spellCast");
        return spell != null && event.getTargetId().equals(spell.getCard().getId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        if (creature != null) {
            creature.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game, event.getAppliedEffects());
            this.discard();
        }
        return false;
    }

    public BorealOutriderEffect copy() {
        return new BorealOutriderEffect(this);
    }
}

