/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.AttachedToMatchesFilterCondition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.abilities.keyword.ChannelAbility;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.permanent.token.PilotCrewToken;
import mage.game.permanent.token.Token;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class BornToDrive
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent();
    private static final DynamicValue xValue;
    private static final Hint hint;
    private static final Condition condition;

    public BornToDrive(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{W}");
        this.subtype.add((Object)SubType.AURA);
        TargetPermanent auraTarget = new TargetPermanent(StaticFilters.FILTER_PERMANENT_ARTIFACT_OR_CREATURE);
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        this.addAbility((Ability)new EnchantAbility((Target)auraTarget));
        this.addAbility(new SimpleStaticAbility((Effect)new ConditionalContinuousEffect((ContinuousEffect)new BoostEnchantedEffect(xValue, xValue), condition, "as long as enchanted permanent is a creature, it gets +1/+1 for each creature and/or Vehicle you control")).addHint(hint));
        this.addAbility((Ability)new ChannelAbility("{2}{W}", (Effect)new CreateTokenEffect((Token)new PilotCrewToken(), 2)));
    }

    private BornToDrive(BornToDrive card) {
        super((CardImpl)card);
    }

    public BornToDrive copy() {
        return new BornToDrive(this);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)SubType.VEHICLE.getPredicate()));
        xValue = new PermanentsOnBattlefieldCount(filter);
        hint = new ValueHint("Creatures and Vehicles you control", xValue);
        condition = new AttachedToMatchesFilterCondition((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
    }
}

