/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.keyword.FlashbackAbility;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class BosiumStripCastFromGraveyardEffect
extends AsThoughEffectImpl {
    BosiumStripCastFromGraveyardEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "Until end of turn, if the top card of your graveyard is an instant or sorcery card, you may cast that card";
    }

    private BosiumStripCastFromGraveyardEffect(BosiumStripCastFromGraveyardEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public BosiumStripCastFromGraveyardEffect copy() {
        return new BosiumStripCastFromGraveyardEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (!(source instanceof FlashbackAbility) && affectedControllerId.equals(source.getControllerId())) {
            Player player = game.getPlayer(affectedControllerId);
            Card card = game.getCard(objectId);
            if (card != null && player != null && card.equals(player.getGraveyard().getTopCard(game)) && StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY.match(card, game) && game.getState().getZone(objectId) == Zone.GRAVEYARD) {
                game.getState().setValue("BosiumStrip", (Object)card);
                return true;
            }
        }
        return false;
    }
}

