/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.players.Player;
import mage.watchers.common.CastFromGraveyardWatcher;

class BosiumStripReplacementEffect
extends ReplacementEffectImpl {
    BosiumStripReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.Exile);
        this.staticText = "If a card cast this way would be put into a graveyard this turn, exile it instead";
    }

    private BosiumStripReplacementEffect(BosiumStripReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public BosiumStripReplacementEffect copy() {
        return new BosiumStripReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = (Card)game.getState().getValue("BosiumStrip");
        if (card == null) {
            return false;
        }
        ((ZoneChangeEvent)event).setToZone(Zone.EXILED);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getToZone() != Zone.GRAVEYARD) {
            return false;
        }
        Card card = game.getCard(event.getSourceId());
        if (card == null) {
            return false;
        }
        if (!StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY.match(card, game)) {
            return false;
        }
        CastFromGraveyardWatcher watcher = (CastFromGraveyardWatcher)game.getState().getWatcher(CastFromGraveyardWatcher.class);
        return watcher != null && watcher.spellWasCastFromGraveyard(event.getTargetId(), game.getState().getZoneChangeCounter(event.getTargetId()));
    }
}

