/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledLandPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetOpponentsCreaturePermanent;

class BosskTriggeredAbility
extends TriggeredAbilityImpl {
    BosskTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersTargetEffect(CounterType.BOUNTY.createInstance()));
        this.addTarget((Target)new TargetOpponentsCreaturePermanent());
    }

    private BosskTriggeredAbility(BosskTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkInterveningIfClause(Game game) {
        return game.getBattlefield().count((FilterPermanent)new FilterControlledLandPermanent(), this.getControllerId(), (Ability)this, game) > 4;
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        return permanent != null && permanent.isLand(game) && permanent.isControlledBy(this.getControllerId());
    }

    public BosskTriggeredAbility copy() {
        return new BosskTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a land enter the battlefield under your control, if you control five or more lands, put a bounty counter on target creature an opponet controls";
    }
}

