/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;
import mage.watchers.common.BoostCountersAddedFirstTimeWatcher;

class BotanicalBrawlerTriggeredAbility
extends TriggeredAbilityImpl {
    BotanicalBrawlerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance()));
        this.addWatcher((Watcher)new BoostCountersAddedFirstTimeWatcher());
    }

    private BotanicalBrawlerTriggeredAbility(BotanicalBrawlerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public BotanicalBrawlerTriggeredAbility copy() {
        return new BotanicalBrawlerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        int offset = 0;
        if (permanent == null) {
            permanent = game.getPermanentEntering(event.getTargetId());
            ++offset;
        }
        return permanent != null && !this.getSourceId().equals(event.getTargetId()) && this.isControlledBy(permanent.getControllerId()) && event.getData().equals(CounterType.P1P1.getName()) && BoostCountersAddedFirstTimeWatcher.checkEvent((GameEvent)event, (Permanent)permanent, (Game)game, (int)offset);
    }

    public String getRule() {
        return "Whenever one or more +1/+1 counters are put on another permanent you control, if it's the first time +1/+1 counters have been put on that permanent this turn, put a +1/+1 counter on {this}.";
    }
}

