/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceTargetsPermanentCondition;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.GreatestAmongPermanentsValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.ExileTargetIfDiesEffect;
import mage.abilities.effects.common.cost.SpellCostReductionSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.target.Target;
import mage.target.common.TargetCreatureOrPlaneswalker;

public final class BouncersBeatdown
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent("a black permanent");
    private static final Condition condition;

    public BouncersBeatdown(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{2}{G}");
        this.addAbility(new SimpleStaticAbility(Zone.ALL, (Effect)new SpellCostReductionSourceEffect(2, condition).setCanWorksOnStackOnly(true)).setRuleAtTheTop(true));
        this.getSpellAbility().addEffect((Effect)new DamageTargetEffect((DynamicValue)GreatestAmongPermanentsValue.POWER_CONTROLLED_CREATURES).setText("{this} deals X damage to target creature or planeswalker, where X is the greatest power among creatures you control"));
        this.getSpellAbility().addHint(GreatestAmongPermanentsValue.POWER_CONTROLLED_CREATURES.getHint());
        this.getSpellAbility().addTarget((Target)new TargetCreatureOrPlaneswalker());
        this.getSpellAbility().addEffect((Effect)new ExileTargetIfDiesEffect("creature or planeswalker"));
    }

    private BouncersBeatdown(BouncersBeatdown card) {
        super((CardImpl)card);
    }

    public BouncersBeatdown copy() {
        return new BouncersBeatdown(this);
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.BLACK));
        condition = new SourceTargetsPermanentCondition(filter);
    }
}

