/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BoundByMoonsilverEffect
extends RestrictionEffect {
    BoundByMoonsilverEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "enchanted creature can't attack, block, or transform";
    }

    private BoundByMoonsilverEffect(BoundByMoonsilverEffect effect) {
        super((RestrictionEffect)effect);
    }

    public BoundByMoonsilverEffect copy() {
        return new BoundByMoonsilverEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getAttachments().contains(source.getSourceId());
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean canTransform(Game game, boolean canUseChooseDialogs) {
        return false;
    }
}

