/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.common.TargetSacrifice;

class BoundEffect
extends OneShotEffect {
    BoundEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Sacrifice a creature. Return up to X cards from your graveyard to your hand, where X is the number of colors that creature was";
    }

    private BoundEffect(BoundEffect effect) {
        super((OneShotEffect)effect);
    }

    public BoundEffect copy() {
        return new BoundEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent toSacrifice;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
        if (target.canChoose(controller.getId(), source, game) && controller.chooseTarget(this.outcome, (Target)target, source, game) && (toSacrifice = game.getPermanent(target.getFirstTarget())) != null) {
            toSacrifice.sacrifice(source, game);
            game.processAction();
            int colors = toSacrifice.getColor(game).getColorCount();
            if (colors > 0) {
                TargetCardInYourGraveyard targetCard = new TargetCardInYourGraveyard(0, colors, new FilterCard("up to " + colors + " card" + (colors > 1 ? "s" : "") + " from your graveyard"));
                controller.chooseTarget(this.outcome, (Target)targetCard, source, game);
                controller.moveCards((Cards)new CardsImpl((Collection)targetCard.getTargets()), Zone.HAND, source, game);
            }
        }
        return true;
    }
}

