/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class BoxingRingWatcher
extends Watcher {
    private final Set<MageObjectReference> morSet = new HashSet<MageObjectReference>();

    BoxingRingWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.FIGHTED_PERMANENT) {
            this.morSet.add(new MageObjectReference((MageObject)game.getPermanent(event.getTargetId()), game));
        }
    }

    public void reset() {
        super.reset();
        this.morSet.clear();
    }

    static boolean checkPlayer(UUID playerId, Game game) {
        return ((BoxingRingWatcher)game.getState().getWatcher(BoxingRingWatcher.class)).morSet.stream().filter(mor -> mor.zoneCounterIsCurrent(game)).map(MageObjectReference::getSourceId).map(arg_0 -> ((Game)game).getControllerId(arg_0)).anyMatch(playerId::equals);
    }
}

