/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BraidedNetEffect
extends RestrictionEffect {
    BraidedNetEffect() {
        super(Duration.Custom);
        this.staticText = "its activated abilities can't be activated for as long as it remains tapped";
    }

    private BraidedNetEffect(BraidedNetEffect effect) {
        super((RestrictionEffect)effect);
    }

    public BraidedNetEffect copy() {
        return new BraidedNetEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(this.getTargetPointer().getFirst(game, source));
    }

    public boolean canUseActivatedAbilities(Permanent permanent, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean isInactive(Ability source, Game game) {
        if (super.isInactive(source, game)) {
            return true;
        }
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        return permanent == null || !permanent.isTapped();
    }
}

