/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.SharesCardTypePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;
import mage.util.CardUtil;

class BraidsArisenNightmareEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("an artifact, creature, enchantment, land, or planeswalker");

    public BraidsArisenNightmareEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "you may sacrifice an artifact, creature, enchantment, land, or planeswalker. If you do, each opponent may sacrifice a permanent of their choice that shares a card type with it. For each opponent who doesn't, that player loses 2 life and you draw a card";
    }

    private BraidsArisenNightmareEffect(BraidsArisenNightmareEffect effect) {
        super((OneShotEffect)effect);
    }

    public BraidsArisenNightmareEffect copy() {
        return new BraidsArisenNightmareEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice((FilterPermanent)filter);
        if (!target.canChoose(controller.getId(), source, game)) {
            return false;
        }
        controller.choose(Outcome.Sacrifice, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        SharesCardTypePredicate predicate = new SharesCardTypePredicate((Collection)permanent.getCardType(game));
        FilterControlledPermanent opponentFilter = new FilterControlledPermanent(predicate.toString());
        opponentFilter.add((Predicate)predicate);
        if (!permanent.sacrifice(source, game)) {
            return false;
        }
        for (UUID opponentId : game.getOpponents(controller.getId(), true)) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || this.braidsSacrifice(opponent, opponentFilter, game, source)) continue;
            opponent.loseLife(2, game, source, false);
            controller.drawCards(1, source, game);
        }
        return true;
    }

    private boolean braidsSacrifice(Player opponent, FilterControlledPermanent opponentFilter, Game game, Ability source) {
        TargetSacrifice target = new TargetSacrifice((FilterPermanent)opponentFilter);
        if (!target.canChoose(opponent.getId(), source, game)) {
            return false;
        }
        if (!opponent.chooseUse(Outcome.Sacrifice, "Sacrifice " + CardUtil.addArticle((String)opponentFilter.getMessage()) + '?', source, game)) {
            return false;
        }
        opponent.choose(Outcome.Sacrifice, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        return permanent != null && permanent.sacrifice(source, game);
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.ENCHANTMENT.getPredicate(), CardType.LAND.getPredicate(), CardType.PLANESWALKER.getPredicate()}));
    }
}

