/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class BraidssFrightfulReturnEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("nonland, nontoken permanent");

    public BraidssFrightfulReturnEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Target opponent may sacrifice a nonland, nontoken permanent. If they don't, they lose 2 life and you draw a card.";
    }

    private BraidssFrightfulReturnEffect(BraidssFrightfulReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public BraidssFrightfulReturnEffect copy() {
        return new BraidssFrightfulReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        TargetControlledPermanent target = new TargetControlledPermanent(1, 1, filter, true);
        boolean sacrifice = false;
        if (target.canChoose(opponent.getId(), source, game) && opponent.chooseUse(this.outcome, "Sacrifice a nonland, nontoken permanent?", source, game)) {
            opponent.chooseTarget(this.outcome, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            boolean bl = sacrifice = permanent != null && permanent.sacrifice(source, game);
        }
        if (!sacrifice) {
            opponent.loseLife(2, game, source, false);
            controller.drawCards(1, source, game);
        }
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)CardType.LAND.getPredicate()));
        filter.add((Predicate)TokenPredicate.FALSE);
    }
}

