/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BrandedBrawlersCantBlockEffect
extends RestrictionEffect {
    private final FilterPermanent filter;

    public BrandedBrawlersCantBlockEffect(FilterPermanent filter) {
        super(Duration.WhileOnBattlefield);
        this.filter = filter;
        this.staticText = "{this} can't block if you control " + filter.getMessage();
    }

    private BrandedBrawlersCantBlockEffect(BrandedBrawlersCantBlockEffect effect) {
        super((RestrictionEffect)effect);
        this.filter = effect.filter;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId());
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        Player player = game.getPlayer(blocker.getControllerId());
        if (player != null) {
            return game.getBattlefield().countAll(this.filter, player.getId(), game) <= 0;
        }
        return true;
    }

    public BrandedBrawlersCantBlockEffect copy() {
        return new BrandedBrawlersCantBlockEffect(this);
    }
}

