/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.b.BreathOfFuryEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class BreathOfFuryAbility
extends TriggeredAbilityImpl {
    public BreathOfFuryAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BreathOfFuryEffect());
        this.setTriggerPhrase("When enchanted creature deals combat damage to a player, ");
    }

    private BreathOfFuryAbility(BreathOfFuryAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public BreathOfFuryAbility copy() {
        return new BreathOfFuryAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent creature;
        DamagedPlayerEvent damageEvent = (DamagedPlayerEvent)event;
        Permanent enchantment = game.getPermanent(this.getSourceId());
        if (damageEvent.isCombatDamage() && enchantment != null && enchantment.isAttachedTo(event.getSourceId()) && (creature = game.getPermanent(enchantment.getAttachedTo())) != null) {
            for (Effect effect : this.getEffects()) {
                effect.setValue("TriggeringCreatureId", (Object)creature.getId());
            }
            return true;
        }
        return false;
    }
}

