/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.common.CastFromGraveyardWatcher;

class BreathlessKnightTriggeredAbility
extends TriggeredAbilityImpl {
    public BreathlessKnightTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance()));
        this.setTriggerPhrase("Whenever {this} or another creature you control enters, if that creature entered from a graveyard or you cast it from a graveyard, ");
    }

    private BreathlessKnightTriggeredAbility(BreathlessKnightTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public BreathlessKnightTriggeredAbility copy() {
        return new BreathlessKnightTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        EntersTheBattlefieldEvent entersEvent;
        Permanent permanent;
        if (event instanceof EntersTheBattlefieldEvent && (permanent = (entersEvent = (EntersTheBattlefieldEvent)event).getTarget()) != null && permanent.isCreature(game) && permanent.isControlledBy(this.getControllerId())) {
            if (entersEvent.getFromZone() == Zone.GRAVEYARD) {
                return true;
            }
            CastFromGraveyardWatcher watcher = (CastFromGraveyardWatcher)game.getState().getWatcher(CastFromGraveyardWatcher.class);
            int zcc = game.getState().getZoneChangeCounter(entersEvent.getSourceId());
            return watcher != null && watcher.spellWasCastFromGraveyard(entersEvent.getSourceId(), zcc - 1);
        }
        return false;
    }
}

