/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class BreechesBrazenPlundererEffect
extends OneShotEffect {
    private final Set<UUID> opponentIds = new HashSet<UUID>();

    BreechesBrazenPlundererEffect(Set<UUID> opponentIds) {
        super(Outcome.Benefit);
        this.opponentIds.addAll(opponentIds);
    }

    private BreechesBrazenPlundererEffect(BreechesBrazenPlundererEffect effect) {
        super((OneShotEffect)effect);
        this.opponentIds.addAll(effect.opponentIds);
    }

    public BreechesBrazenPlundererEffect copy() {
        return new BreechesBrazenPlundererEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        this.opponentIds.stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(Player::getLibrary).map(library -> library.getFromTop(game)).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.removeIf(uuid -> game.getState().getZone(uuid) != Zone.EXILED);
        if (cards.isEmpty()) {
            return false;
        }
        for (Card card : cards.getCards(game)) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.EndOfTurn, (boolean)true);
        }
        return true;
    }
}

