/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.PermanentsSacrificedWatcher;

enum BriarbridgePatrolCondition implements Condition
{
    instance;


    public boolean apply(Game game, Ability source) {
        List sacrificedPermanents;
        PermanentsSacrificedWatcher watcher = (PermanentsSacrificedWatcher)game.getState().getWatcher(PermanentsSacrificedWatcher.class);
        if (watcher != null && (sacrificedPermanents = watcher.getThisTurnSacrificedPermanents(source.getControllerId())) != null && !sacrificedPermanents.isEmpty()) {
            int amountOfClues = 0;
            for (Permanent permanent : sacrificedPermanents) {
                if (!permanent.hasSubtype(SubType.CLUE, game)) continue;
                ++amountOfClues;
            }
            return amountOfClues > 2;
        }
        return false;
    }

    public String toString() {
        return "if you sacrificed three or more Clues this turn";
    }
}

