/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.turn.TurnMod;
import mage.players.Player;

class BrineElementalEffect
extends OneShotEffect {
    BrineElementalEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent skips their next untap step";
    }

    private BrineElementalEffect(BrineElementalEffect effect) {
        super((OneShotEffect)effect);
    }

    public BrineElementalEffect copy() {
        return new BrineElementalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                if (!controller.hasOpponent(playerId, game)) continue;
                game.getState().getTurnMods().add(new TurnMod(playerId).withSkipStep(PhaseStep.UNTAP));
            }
            return true;
        }
        return false;
    }
}

