/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.Target;
import mage.target.common.TargetNonlandPermanent;

class BrinelinTheMoonKrakenTriggeredAbility
extends TriggeredAbilityImpl {
    BrinelinTheMoonKrakenTriggeredAbility() {
        super(Zone.ALL, (Effect)new ReturnToHandTargetEffect(), true);
        this.addTarget((Target)new TargetNonlandPermanent());
    }

    private BrinelinTheMoonKrakenTriggeredAbility(BrinelinTheMoonKrakenTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST || event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        switch (event.getType()) {
            case SPELL_CAST: {
                if (!event.getPlayerId().equals(this.getControllerId()) || game.getPermanent(this.getSourceId()) == null) {
                    return false;
                }
                Spell spell = game.getSpellOrLKIStack(event.getTargetId());
                return spell != null && spell.getManaValue() >= 6;
            }
            case ENTERS_THE_BATTLEFIELD: {
                return event.getTargetId().equals(this.getSourceId());
            }
        }
        return false;
    }

    public String getRule() {
        return "When {this} enters or whenever you cast a spell with mana value 6 or greater, you may return target nonland permanent to its owner's hand.";
    }

    public BrinelinTheMoonKrakenTriggeredAbility copy() {
        return new BrinelinTheMoonKrakenTriggeredAbility(this);
    }
}

