/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CounterTargetEffect;
import mage.abilities.effects.common.CounterUnlessPaysEffect;
import mage.constants.AbilityWord;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class BringTheEndingCounterEffect
extends OneShotEffect {
    BringTheEndingCounterEffect() {
        super(Outcome.Benefit);
        this.staticText = "Counter target spell unless its controller pays {2}.<br>" + AbilityWord.CORRUPTED.formatWord() + "Counter that spell instead if its controller has three or more poison counters.";
    }

    private BringTheEndingCounterEffect(BringTheEndingCounterEffect effect) {
        super((OneShotEffect)effect);
    }

    public BringTheEndingCounterEffect copy() {
        return new BringTheEndingCounterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CounterTargetEffect hardCounterEffect = new CounterTargetEffect();
        CounterUnlessPaysEffect softCounterEffect = new CounterUnlessPaysEffect((Cost)new GenericManaCost(2));
        UUID targetId = source.getFirstTarget();
        UUID controllerId = game.getControllerId(targetId);
        Player player = game.getPlayer(controllerId);
        if (player != null && player.getCountersCount(CounterType.POISON) >= 3) {
            hardCounterEffect.setTargetPointer(this.getTargetPointer().copy());
            return hardCounterEffect.apply(game, source);
        }
        softCounterEffect.setTargetPointer(this.getTargetPointer().copy());
        return softCounterEffect.apply(game, source);
    }
}

