/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ClashEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class BrokenAmbitionsEffect
extends OneShotEffect {
    BrokenAmbitionsEffect() {
        super(Outcome.Benefit);
        this.staticText = "Clash with an opponent. If you win, that spell's controller mills four cards";
    }

    private BrokenAmbitionsEffect(BrokenAmbitionsEffect effect) {
        super((OneShotEffect)effect);
    }

    public BrokenAmbitionsEffect copy() {
        return new BrokenAmbitionsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpellOrLKIStack(source.getFirstTarget());
        if (spell == null) {
            return false;
        }
        Player player = game.getPlayer(spell.getControllerId());
        if (player == null) {
            return false;
        }
        if (new ClashEffect().apply(game, source)) {
            player.millCards(4, source, game);
        }
        return true;
    }
}

