/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.common.AbilityResolvedWatcher;

class BronzeCudgelsEffect
extends OneShotEffect {
    BronzeCudgelsEffect() {
        super(Outcome.Benefit);
        this.staticText = "until end of turn, equipped creature gets +X/+0, where X is the number of times this ability has resolved this turn.";
    }

    private BronzeCudgelsEffect(BronzeCudgelsEffect effect) {
        super((OneShotEffect)effect);
    }

    public BronzeCudgelsEffect copy() {
        return new BronzeCudgelsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (permanent == null || game.getPermanent(permanent.getAttachedTo()) == null) {
            return false;
        }
        int resolvedCount = AbilityResolvedWatcher.getResolutionCount((Game)game, (Ability)source);
        if (resolvedCount < 1) {
            return false;
        }
        game.addEffect(new BoostTargetEffect(resolvedCount, 0).setTargetPointer((TargetPointer)new FixedTarget(permanent.getAttachedTo(), game)), source);
        return true;
    }
}

