/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Objects;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;

class BrotherhoodScribeAbility
extends TriggeredAbilityImpl {
    BrotherhoodScribeAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BoostControlledEffect(1, 1, Duration.EndOfTurn));
        this.setTriggerPhrase("Whenever you get one or more {E} during your turn, ");
    }

    private BrotherhoodScribeAbility(BrotherhoodScribeAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getData().equals(CounterType.ENERGY.getName()) && game.isActivePlayer(this.getControllerId())) {
            return Objects.equals(event.getTargetId(), this.getControllerId());
        }
        return false;
    }

    public BrotherhoodScribeAbility copy() {
        return new BrotherhoodScribeAbility(this);
    }
}

