/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BrothersYamazakiIgnoreLegendRuleEffectEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterPermanent();

    public BrothersYamazakiIgnoreLegendRuleEffectEffect() {
        super(Duration.WhileOnBattlefield, Layer.RulesEffects, SubLayer.NA, Outcome.Detriment);
        this.staticText = "If there are exactly two permanents named Brothers Yamazaki on the battlefield, the \"legend rule\" doesn't apply to them";
    }

    private BrothersYamazakiIgnoreLegendRuleEffectEffect(BrothersYamazakiIgnoreLegendRuleEffectEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public BrothersYamazakiIgnoreLegendRuleEffectEffect copy() {
        return new BrothersYamazakiIgnoreLegendRuleEffectEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game);
        if (permanents.size() != 2) {
            return false;
        }
        for (Permanent permanent : permanents) {
            permanent.setLegendRuleApplies(false);
        }
        return true;
    }

    static {
        filter.add((Predicate)new NamePredicate("Brothers Yamazaki"));
    }
}

