/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class BrowbeatDrawEffect
extends OneShotEffect {
    BrowbeatDrawEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Any player may have {this} deal 5 damage to them. If no one does, target player draws three cards.";
    }

    private BrowbeatDrawEffect(BrowbeatDrawEffect effect) {
        super((OneShotEffect)effect);
    }

    public BrowbeatDrawEffect copy() {
        return new BrowbeatDrawEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Object spell = null;
        for (Object object : game.getStack()) {
            if (!(object instanceof Spell) || !object.getSourceId().equals(source.getSourceId())) continue;
            spell = object;
        }
        if (spell != null) {
            Player player;
            UUID targetPlayer;
            boolean drawCards = true;
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player2 = game.getPlayer(playerId);
                if (player2 == null || !player2.chooseUse(Outcome.Detriment, "Have " + spell.getLogName() + " deal 5 damage to you?", source, game)) continue;
                drawCards = false;
                player2.damage(5, source.getSourceId(), source, game);
                game.informPlayers(player2.getLogName() + " has " + spell.getLogName() + " deal 5 to them");
            }
            if (drawCards && (targetPlayer = this.getTargetPointer().getFirst(game, source)) != null && (player = game.getPlayer(targetPlayer)) != null) {
                player.drawCards(3, source, game);
            }
            return drawCards;
        }
        return false;
    }
}

