/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class BruvacTheGrandiloquentReplacementEffect
extends ReplacementEffectImpl {
    BruvacTheGrandiloquentReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "If an opponent would mill one or more cards, they mill twice that many cards instead";
    }

    private BruvacTheGrandiloquentReplacementEffect(BruvacTheGrandiloquentReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public BruvacTheGrandiloquentReplacementEffect copy() {
        return new BruvacTheGrandiloquentReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.MILL_CARDS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return game.getOpponents(source.getControllerId()).contains(event.getPlayerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

