/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

public final class BuccaneersBravado
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent("Pirate");

    public BuccaneersBravado(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{1}{R}");
        this.getSpellAbility().addTarget((Target)new TargetCreaturePermanent());
        this.getSpellAbility().addEffect((Effect)new BoostTargetEffect(1, 1, Duration.EndOfTurn).setText("Target creature gets +1/+1"));
        this.getSpellAbility().addEffect((Effect)new GainAbilityTargetEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn).setText("and gains first strike until end of turn"));
        Mode mode = new Mode((Effect)new BoostTargetEffect(1, 1, Duration.EndOfTurn).setText("Target Pirate gets +1/+1"));
        mode.addEffect((Effect)new GainAbilityTargetEffect((Ability)DoubleStrikeAbility.getInstance(), Duration.EndOfTurn).setText("and gains double strike until end of turn"));
        mode.addTarget((Target)new TargetPermanent(filter));
        this.getSpellAbility().addMode(mode);
    }

    private BuccaneersBravado(BuccaneersBravado card) {
        super((CardImpl)card);
    }

    public BuccaneersBravado copy() {
        return new BuccaneersBravado(this);
    }

    static {
        filter.add((Predicate)SubType.PIRATE.getPredicate());
    }
}

