/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class BucolicRanchEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("a Mount card");

    BucolicRanchEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top card of your library. If it's a Mount card, you may reveal it and put it into your hand. If you don't put it into your hand, you may put it on the bottom of your library";
    }

    private BucolicRanchEffect(BucolicRanchEffect effect) {
        super((OneShotEffect)effect);
    }

    public BucolicRanchEffect copy() {
        return new BucolicRanchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.lookAtCards("Top card of library", card, game);
        if (filter.match(card, player.getId(), source, game) && player.chooseUse(this.outcome, "Put " + card.getName() + " into your hand?", source, game)) {
            player.revealCards(source, (Cards)new CardsImpl(card), game);
            player.moveCards(card, Zone.HAND, source, game);
        }
        if (Zone.LIBRARY.equals((Object)game.getState().getZone(card.getId())) && player.chooseUse(this.outcome, "Put " + card.getName() + " on the bottom of your library?", source, game)) {
            player.putCardsOnBottomOfLibrary(card, game, source);
        }
        return true;
    }

    static {
        filter.add((Predicate)SubType.MOUNT.getPredicate());
    }
}

