/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.PutCardFromHandOntoBattlefieldEffect;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class BurgeoningTriggeredAbility
extends TriggeredAbilityImpl {
    BurgeoningTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new PutCardFromHandOntoBattlefieldEffect((FilterCard)StaticFilters.FILTER_CARD_LAND_A));
    }

    private BurgeoningTriggeredAbility(BurgeoningTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LAND_PLAYED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent land = game.getPermanent(event.getTargetId());
        return land != null && game.getOpponents(this.controllerId).contains(land.getControllerId());
    }

    public BurgeoningTriggeredAbility copy() {
        return new BurgeoningTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever an opponent plays a land, you may put a land card from your hand onto the battlefield.";
    }
}

