/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BurnAtTheStakeEffect
extends OneShotEffect {
    BurnAtTheStakeEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals damage to any target equal to three times the number of creatures tapped this way";
    }

    private BurnAtTheStakeEffect(BurnAtTheStakeEffect effect) {
        super((OneShotEffect)effect);
    }

    public BurnAtTheStakeEffect copy() {
        return new BurnAtTheStakeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amount = GetXValue.instance.calculate(game, source, (Effect)this) * 3;
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            permanent.damage(amount, source.getSourceId(), source, game, false, true);
            return true;
        }
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            player.damage(amount, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }
}

