/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.LoseAbilityTargetEffect;
import mage.abilities.effects.common.replacement.DiesReplacementEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class BurnFromWithinEffect
extends OneShotEffect {
    BurnFromWithinEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals X damage to any target. If a creature is dealt damage this way, it loses indestructible until end of turn. If that creature would die this turn, exile it instead";
    }

    private BurnFromWithinEffect(BurnFromWithinEffect effect) {
        super((OneShotEffect)effect);
    }

    public BurnFromWithinEffect copy() {
        return new BurnFromWithinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int amount = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (creature != null) {
            game.addEffect((ContinuousEffect)new DiesReplacementEffect(new MageObjectReference((MageObject)creature, game), Duration.EndOfTurn), source);
            int damageDealt = creature.damage(amount, source.getSourceId(), source, game, false, true);
            if (damageDealt > 0) {
                LoseAbilityTargetEffect effect = new LoseAbilityTargetEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(creature.getId(), game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer != null) {
            targetPlayer.damage(amount, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }
}

