/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BurningHandsEffect
extends OneShotEffect {
    BurningHandsEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 2 damage to target creature or planeswalker. If that permanent is green, {this} deals 6 damage instead";
    }

    private BurningHandsEffect(BurningHandsEffect effect) {
        super((OneShotEffect)effect);
    }

    public BurningHandsEffect copy() {
        return new BurningHandsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        return permanent.damage(permanent.getColor(game).isGreen() ? 6 : 2, source.getSourceId(), source, game) > 0;
    }
}

