/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInYourGraveyard;

class FetchQuestEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("creature, enchantment, or land card");

    FetchQuestEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill seven cards. Then put a creature, enchantment, or land card from among the milled cards onto the battlefield";
    }

    private FetchQuestEffect(FetchQuestEffect effect) {
        super((OneShotEffect)effect);
    }

    public FetchQuestEffect copy() {
        return new FetchQuestEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Cards cards = player.millCards(7, source, game);
        if (cards.count(filter, game) < 1) {
            return true;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(1, 1, filter, true);
        player.choose(Outcome.PutCardInPlay, cards, (TargetCard)target, source, game);
        player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.BATTLEFIELD, source, game);
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.CREATURE.getPredicate(), CardType.ENCHANTMENT.getPredicate(), CardType.LAND.getPredicate()}));
    }
}

