/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class MoveCounterFromTargetToTargetEffect
extends OneShotEffect {
    MoveCounterFromTargetToTargetEffect() {
        super(Outcome.Detriment);
        this.staticText = "Move any number of +1/+1 counters from target creature onto another target creature with the same controller";
    }

    private MoveCounterFromTargetToTargetEffect(MoveCounterFromTargetToTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public MoveCounterFromTargetToTargetEffect copy() {
        return new MoveCounterFromTargetToTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int amountToMove;
            Permanent fromPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            Permanent toPermanent = null;
            if (source.getTargets().size() > 1) {
                toPermanent = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
            }
            if (fromPermanent == null || toPermanent == null || !fromPermanent.isControlledBy(toPermanent.getControllerId())) {
                return false;
            }
            int amountCounters = fromPermanent.getCounters(game).getCount(CounterType.P1P1);
            if (amountCounters > 0 && (amountToMove = controller.getAmount(0, amountCounters, "Choose how many counters to move", source, game)) > 0) {
                fromPermanent.removeCounters(CounterType.P1P1.createInstance(amountToMove), source, game);
                toPermanent.addCounters(CounterType.P1P1.createInstance(amountToMove), source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }
}

