/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class ReturnToHandEffect
extends OneShotEffect {
    ReturnToHandEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "That player returns a permanent they control to its owner's hand";
    }

    private ReturnToHandEffect(ReturnToHandEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReturnToHandEffect copy() {
        return new ReturnToHandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer == null) {
            return false;
        }
        TargetControlledPermanent target = new TargetControlledPermanent(1, 1, new FilterControlledPermanent(), true);
        if (target.canChoose(targetPlayer.getId(), source, game)) {
            targetPlayer.chooseTarget(Outcome.ReturnToHand, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent != null) {
                targetPlayer.moveCards((Card)permanent, Zone.HAND, source, game);
            }
        }
        return true;
    }
}

