/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class CabalShrineEffect
extends OneShotEffect {
    CabalShrineEffect() {
        super(Outcome.Discard);
        this.staticText = "Whenever a player casts a spell, that player discards X cards, where X is the number of cards in all graveyards with the same name as that spell";
    }

    private CabalShrineEffect(CabalShrineEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Spell spell;
        int count = 0;
        MageObject mageObject = game.getObject(source);
        if (mageObject != null && (spell = (Spell)game.getState().getValue("cabalShrine" + mageObject)) != null && (controller = game.getPlayer(spell.getControllerId())) != null) {
            String name = spell.getName();
            FilterCard filterCardName = new FilterCard();
            filterCardName.add((Predicate)new NamePredicate(name));
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                count += player.getGraveyard().count(filterCardName, game);
            }
            controller.discard(count, false, false, source, game);
            return true;
        }
        return false;
    }

    public CabalShrineEffect copy() {
        return new CabalShrineEffect(this);
    }
}

