/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.costs.common.RevealTargetFromHandCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileAllEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;

class CalamityOfTheTitansEffect
extends OneShotEffect {
    CalamityOfTheTitansEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile each creature and planeswalker with mana value less than the revealed card's mana value";
    }

    private CalamityOfTheTitansEffect(CalamityOfTheTitansEffect effect) {
        super((OneShotEffect)effect);
    }

    public CalamityOfTheTitansEffect copy() {
        return new CalamityOfTheTitansEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        RevealTargetFromHandCost cost = (RevealTargetFromHandCost)source.getCosts().get(0);
        if (cost == null) {
            return false;
        }
        Card card = (Card)cost.getRevealedCards().get(0);
        if (card == null) {
            return false;
        }
        int mv = card.getManaValue();
        FilterPermanent filter = new FilterPermanent();
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.PLANESWALKER.getPredicate()));
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, mv));
        return new ExileAllEffect(filter).apply(game, source);
    }
}

