/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.c.CalixDestinysHandDelayedTriggeredAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.util.CardUtil;

class CalixDestinysHandExileEffect
extends OneShotEffect {
    CalixDestinysHandExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile target creature or enchantment you don't control until target enchantment you control leaves the battlefield.";
    }

    private CalixDestinysHandExileEffect(CalixDestinysHandExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public CalixDestinysHandExileEffect copy() {
        return new CalixDestinysHandExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (source.getTargets().size() > 2) {
            return false;
        }
        source.getTargets();
        Permanent theirPerm = game.getPermanent(((Target)source.getTargets().get(0)).getFirstTarget());
        Permanent myPerm = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        if (controller == null || theirPerm == null || myPerm == null) {
            return false;
        }
        MageObjectReference theirMor = new MageObjectReference(theirPerm.getId(), theirPerm.getZoneChangeCounter(game) + 1, game);
        MageObjectReference myMor = new MageObjectReference((MageObject)myPerm, game);
        UUID exileId = CardUtil.getExileZoneId((String)myPerm.toString(), (Game)game);
        controller.moveCardsToExile((Card)theirPerm, source, game, true, exileId, myPerm.getIdName());
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new CalixDestinysHandDelayedTriggeredAbility(theirMor, myMor), source);
        return true;
    }
}

