/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class CallOfTheDeathDwellerEffect
extends OneShotEffect {
    CallOfTheDeathDwellerEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return up to two target creature cards with total mana value 3 or less from your graveyard to the battlefield. Put a deathtouch counter on either of them. Then put a menace counter on either of them.";
    }

    private CallOfTheDeathDwellerEffect(CallOfTheDeathDwellerEffect effect) {
        super((OneShotEffect)effect);
    }

    public CallOfTheDeathDwellerEffect copy() {
        return new CallOfTheDeathDwellerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player player = game.getPlayer(source.getControllerId());
        CardsImpl cards = new CardsImpl((Collection)source.getTargets().stream().map(Target::getTargets).flatMap(Collection::stream).collect(Collectors.toSet()));
        if (player == null || cards.isEmpty() || !player.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game)) {
            return false;
        }
        List predicates = cards.stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).map(MageItem::getId).map(PermanentIdPredicate::new).collect(Collectors.toList());
        if (predicates.isEmpty()) {
            return false;
        }
        if (predicates.size() == 1) {
            Permanent permanent2 = game.getPermanent((UUID)cards.stream().findFirst().orElse(null));
            if (permanent2 != null) {
                permanent2.addCounters(CounterType.DEATHTOUCH.createInstance(), source.getControllerId(), source, game);
                permanent2.addCounters(CounterType.MENACE.createInstance(), source.getControllerId(), source, game);
            }
            return true;
        }
        FilterPermanent filter = new FilterPermanent("creature to put a deathtouch counter on");
        filter.add(Predicates.or(predicates));
        TargetPermanent target = new TargetPermanent(0, 1, filter, true);
        if (player.choose(this.outcome, (Target)target, source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null) {
            permanent.addCounters(CounterType.DEATHTOUCH.createInstance(), source.getControllerId(), source, game);
        }
        filter.setMessage("creature to put a menace counter on");
        target = new TargetPermanent(0, 1, filter, true);
        if (player.choose(this.outcome, (Target)target, source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null) {
            permanent.addCounters(CounterType.MENACE.createInstance(), source.getControllerId(), source, game);
        }
        return true;
    }
}

