/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class CamaraderieEffect
extends OneShotEffect {
    CamaraderieEffect() {
        super(Outcome.Benefit);
        this.staticText = "You gain X life and draw X cards, where X is the number of creatures you control. Creatures you control get +1/+1 until end of turn.";
    }

    private CamaraderieEffect(CamaraderieEffect effect) {
        super((OneShotEffect)effect);
    }

    public CamaraderieEffect copy() {
        return new CamaraderieEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int xValue = game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game);
        player.gainLife(xValue, game, source);
        player.drawCards(xValue, source, game);
        game.addEffect((ContinuousEffect)new BoostControlledEffect(1, 1, Duration.EndOfTurn), source);
        return true;
    }
}

