/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;

class CankerAbominationEffect
extends OneShotEffect {
    CankerAbominationEffect() {
        super(Outcome.Neutral);
        this.staticText = "choose an opponent. {this} enters with a -1/-1 counter on it for each creature that player controls";
    }

    private CankerAbominationEffect(CankerAbominationEffect effect) {
        super((OneShotEffect)effect);
    }

    public CankerAbominationEffect copy() {
        return new CankerAbominationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent cankerAbomination = game.getPermanentEntering(source.getSourceId());
        if (controller != null && cankerAbomination != null) {
            TargetOpponent target = new TargetOpponent();
            target.withNotTarget(true);
            controller.choose(this.outcome, (Target)target, source, game);
            Player opponent = game.getPlayer(target.getFirstTarget());
            if (opponent != null) {
                game.informPlayers(cankerAbomination.getName() + ": " + controller.getLogName() + " has chosen " + opponent.getLogName());
                int amount = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, opponent.getId(), game).size();
                if (amount > 0) {
                    cankerAbomination.addCounters(CounterType.M1M1.createInstance(amount), source.getControllerId(), source, game);
                }
                return true;
            }
        }
        return false;
    }
}

