/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.token.InsectColorlessArtifactToken;
import mage.players.Player;

class CanoptekScarabSwarmEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    CanoptekScarabSwarmEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target player's graveyard. For each artifact or land card exiled this way, create a 1/1 colorless Insect artifact creature token with flying";
    }

    private CanoptekScarabSwarmEffect(CanoptekScarabSwarmEffect effect) {
        super((OneShotEffect)effect);
    }

    public CanoptekScarabSwarmEffect copy() {
        return new CanoptekScarabSwarmEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        int count = player.getGraveyard().count(filter, game);
        player.moveCards((Cards)player.getGraveyard(), Zone.EXILED, source, game);
        new InsectColorlessArtifactToken().putOntoBattlefield(count, game, source);
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)CardType.LAND.getPredicate()));
    }
}

