/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.condition.common.IsStepCondition;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.c.CapricopianEffect;
import mage.constants.PhaseStep;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;

class CapricopianActivatedAbility
extends ActivatedAbilityImpl {
    CapricopianActivatedAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance()), (Cost)new GenericManaCost(2));
        this.addEffect((Effect)new CapricopianEffect());
        this.setMayActivate(TargetController.ANY);
        this.condition = new IsStepCondition(PhaseStep.DECLARE_ATTACKERS);
    }

    private CapricopianActivatedAbility(CapricopianActivatedAbility ability) {
        super((ActivatedAbilityImpl)ability);
    }

    public CapricopianActivatedAbility copy() {
        return new CapricopianActivatedAbility(this);
    }

    public String getRule() {
        return "{2}: Put a +1/+1 counter on {this}, then you may reselect which player {this} is attacking. Only the player {this} is attacking may activate this ability and only during the declare attackers step. <i>(It can't attack its controller.)</i>";
    }

    protected boolean checkTargetController(UUID playerId, Game game) {
        return super.checkTargetController(playerId, game) && playerId != null && playerId.equals(game.getCombat().getDefenderId(this.getSourceId()));
    }
}

