/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

class CaptainNghathrodWatcher
extends Watcher {
    private final Set<MageObjectReference> morSet = new HashSet<MageObjectReference>();

    CaptainNghathrodWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ZONE_CHANGE) {
            return;
        }
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getFromZone() == Zone.LIBRARY && zEvent.getToZone() == Zone.GRAVEYARD) {
            this.morSet.add(new MageObjectReference(zEvent.getTargetId(), game));
        }
    }

    public void reset() {
        this.morSet.clear();
        super.reset();
    }

    static boolean checkCard(Card card, Game game) {
        return (card.isCreature(game) || card.isArtifact(game)) && ((CaptainNghathrodWatcher)game.getState().getWatcher(CaptainNghathrodWatcher.class)).morSet.stream().anyMatch(mor -> mor.refersTo((MageObject)card, game));
    }
}

