/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;

class CaptainsManeuverEffect
extends RedirectionEffect {
    protected MageObjectReference redirectToObject;

    public CaptainsManeuverEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, RedirectionEffect.UsageType.ACCORDING_DURATION);
        this.staticText = "The next X damage that would be dealt to target creature, planeswalker, or player this turn is dealt to another target creature, planeswalker, or player instead.";
    }

    private CaptainsManeuverEffect(CaptainsManeuverEffect effect) {
        super((RedirectionEffect)effect);
        this.redirectToObject = effect.redirectToObject;
    }

    public CaptainsManeuverEffect copy() {
        return new CaptainsManeuverEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.amountToRedirect = GetXValue.instance.calculate(game, source, (Effect)this);
        this.redirectToObject = new MageObjectReference(((Target)source.getTargets().get(1)).getFirstTarget(), game);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getTargetId().equals(this.getTargetPointer().getFirst(game, source)) && (game.getPlayer(this.redirectToObject.getSourceId()) != null || game.getControllerId(this.redirectToObject.getSourceId()) != null) && this.redirectToObject.equals((Object)new MageObjectReference(((Target)source.getTargets().get(1)).getFirstTarget(), game))) {
            this.redirectTarget = (Target)source.getTargets().get(1);
            return true;
        }
        return false;
    }
}

